using System;
using System.Collections.Generic;
using System.Text;

namespace DelegateSimple
{
   class Program
   {
      public delegate void MessagePrintDelegate(string msg);
      private delegate int GetCountDelegate(Person obj1, Person obj2);
      protected delegate void LongRunningDelegate(MessagePrintDelegate mpCallBack);

      static void Main(string[] args)
      {
         MessagePrintDelegate mpDel = new MessagePrintDelegate(PrintMessage);
         GetCountDelegate gcd = new GetCountDelegate(GetCount);
         int count = gcd(new Person(), new Person());
         Console.WriteLine("Otrzymano warto: {0}", count);
         LongRunningDelegate lrd = new LongRunningDelegate(LongRunningMethod);
         lrd(mpDel);
         Console.ReadLine();
      }

      static void LongRunningMethod(MessagePrintDelegate mpd)
      {
         for (int i = 0; i < 99; i++)
         {
            if (i % 10 == 0)
            {
               mpd(string.Format("Praca w toku... Wykonano {0}%", i));
            }
         }
      }

      static int GetCount(object obj1, object obj2)
      {
         // wykonaj jakie operacje
         Random rnd = new Random();
         return rnd.Next();
      }

      static void PrintMessage(string msg)
      {
         Console.WriteLine("[{0}] {1}", DateTime.Now.ToShortTimeString(), msg);
      }
   }

   class Person
   {
   }

   class Contact : Person
   {
   }
}
